<?php
// Include necessary files, database models, and other required setups
include_once 'model/companies_model.php';  // Assuming you have a companies model
$companies_model = new companies_model();
$suppliers = $companies_model->get_suppliers(); 
date_default_timezone_set('Africa/Blantyre');
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Manage Suppliers</title>
        <?php
            include_once 'css_links.php';
        ?>
        <style>
            .supplier-modal-header {
    position: relative;
    padding: 20px 30px;
    border-bottom: 1px solid #e5e5e5;
}

.supplier-modal-header .supplier-close {
    position: absolute;   /* <-- forces top-right */
    top: 10px;
    right: 15px;
    float: none;          /* override Bootstrap 3 */
    margin: 0;
    z-index: 10;
}
</style>
    </head>

    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php
                    include 'menu_finance.php';
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            <div class="title_left">
                                <h3><small>Suppliers </small></h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 ">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Manage Suppliers</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Suppliers Overview</h5>
                                        </div>

                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                               <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#addSupplierModal">
                                                    <i class="fa fa-plus-circle"></i> Add Supplier
                                                </button>

                                            </li>
                                            
                                            <li>
                                                <button class="btn btn-info btn-sm" onclick="history.go(-1);    ">
                                                    <i class="fa fa-history"></i> Back
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>

                                    

                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="card-box table-responsive">                                                          
                                                    <?php if (!empty($suppliers)) { ?>
                                                        <table class="table table-bordered table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Name</th>
                                                                    <th>Contact Person</th>
                                                                    <th>Phone</th>
                                                                    <th>Email</th>
                                                                    <th>Status</th>
                                                                    <th style="width: 10%;">Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($suppliers as $supplier) { ?>
                                                                    <tr>
                                                                        <td><?php echo htmlspecialchars($supplier['supplier_name']); ?></td>
                                                                        <td><?php echo htmlspecialchars($supplier['contact_person']); ?></td>
                                                                        <td><?php echo htmlspecialchars($supplier['phone']); ?></td>
                                                                        <td><?php echo htmlspecialchars($supplier['email']); ?></td>
                                                                        
                                                                        <td class="<?php
                                                                            // Adding color-coding based on supplier status
                                                                            $status = $supplier['supplier_state'];

                                                                            if ($status == 1) {
                                                                                echo 'bg-success text-white';
                                                                            } elseif ($status == 0) {
                                                                                echo 'bg-danger text-white';
                                                                            } else {
                                                                                echo 'bg-secondary text-white   ';
                                                                            }
                                                            
                                                                        ?>">
                                                                            <?php echo htmlspecialchars(ucfirst($supplier['supplier_status'])); ?>
                                                                        </td>
                                                                        <td>
                                                                            <!-- Settings (Disabled) -->
                                                                            <a href="javascript:void(0);" onclick="showDisabledNotification()" title="Settings">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-cog"></i>
                                                                                </button>
                                                                            </a>

                                                                            <!-- Enable / Disable -->
                                                                            <?php if ($supplier['supplier_state'] == 1) { ?>
                                                                                <!-- Disable -->
                                                                                <button 
                                                                                    class="btn btn-danger btn-sm toggleSupplierBtn"
                                                                                    data-id="<?= $supplier['id']; ?>"
                                                                                    data-state="1"
                                                                                    data-name="<?= htmlspecialchars($supplier['supplier_name']); ?>"
                                                                                    title="Disable Supplier">
                                                                                    <i class="fa fa-ban"></i>
                                                                                </button>
                                                                            <?php } else { ?>
                                                                                <!-- Enable -->
                                                                                <button 
                                                                                    class="btn btn-success btn-sm toggleSupplierBtn"
                                                                                    data-id="<?= $supplier['id']; ?>"
                                                                                    data-state="0"
                                                                                    data-name="<?= htmlspecialchars($supplier['supplier_name']); ?>"
                                                                                    title="Enable Supplier">
                                                                                    <i class="fa fa-check"></i>
                                                                                </button>
                                                                            <?php } ?>


                                                                            <!-- Edit Supplier -->
                                                                            <button 
                                                                                class="btn btn-warning btn-sm editSupplierBtn"
                                                                                data-id="<?= $supplier['id']; ?>"
                                                                                data-name="<?= htmlspecialchars($supplier['supplier_name']); ?>"
                                                                                data-contact="<?= htmlspecialchars($supplier['contact_person']); ?>"
                                                                                data-phone="<?= htmlspecialchars($supplier['phone']); ?>"
                                                                                data-email="<?= htmlspecialchars($supplier['email']); ?>"
                                                                                title="Edit Supplier">
                                                                                <i class="fa fa-edit"></i>
                                                                            </button>


                                                                        </td>

                                                                    </tr>
                                                                <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php } else { ?>
                                                        <div class="alert alert-info">
                                                            No Supplier data available for display
                                                        </div>
                                                    <?php } ?>
                                                    
                                                  
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php
                    include_once 'footer.php';
                ?>
            </div>
        </div>

        <?php
            include_once 'libraries.php';
        ?>
        <!-- Add Supplier Modal -->
        <div class="modal fade" id="addSupplierModal" tabindex="-1" role="dialog" aria-labelledby="addSupplierLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content supplier-modal">

                    <!-- Header -->
                    <div class="modal-header supplier-modal-header">
                        <button type="button" class="close supplier-close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>

                        <h4 class="modal-title" id="addSupplierLabel">
                            Add Supplier
                        </h4>
                    </div>

                    <!-- Body -->
                    <div class="modal-body supplier-modal-body">
                        <form method="post" action="controllers/company_controller.php" id="addSupplierForm">
                            <input type="hidden" name="action" value="add_supplier" readonly>

                            <div class="form-group">
                                <label>Supplier Name</label>
                                <input type="text" name="supplier_name" class="form-control input-lg" required>
                            </div>

                            <div class="form-group">
                                <label>Contact Person</label>
                                <input type="text" name="contact_person" class="form-control">
                            </div>

                            <div class="form-group">
                                <label>Contact Number</label>
                                <input type="text" name="phone" class="form-control">
                            </div>

                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="email" name="email" class="form-control">
                            </div>

                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer supplier-modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">
                            Cancel
                        </button>
                        <!-- Submit button inside the form -->
                        <button type="submit" class="btn btn-primary" form="addSupplierForm">
                            Save
                        </button>
                    </div>

                </div>
            </div>
        </div>

        <!-- Edit Supplier Modal -->
        <div class="modal fade" id="editSupplierModal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content supplier-modal">

                    <!-- Header -->
                    <div class="modal-header supplier-modal-header">
                        <button type="button" class="close supplier-close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                        <h4 class="modal-title">
                            Edit Supplier
                        </h4>
                    </div>

                    <!-- Body -->
                    <div class="modal-body supplier-modal-body">
                        <form method="post" action="controllers/company_controller.php" id="editSupplierForm">

                            <input type="hidden" name="action" value="update_supplier">
                            <input type="hidden" name="supplier_id" id="edit_supplier_id">

                            <div class="form-group">
                                <label>Supplier Name</label>
                                <input type="text" name="supplier_name" id="edit_supplier_name" class="form-control input-lg" required>
                            </div>

                            <div class="form-group">
                                <label>Contact Person</label>
                                <input type="text" name="contact_person" id="edit_contact_person" class="form-control">
                            </div>

                            <div class="form-group">
                                <label>Contact Number</label>
                                <input type="text" name="phone" id="edit_phone" class="form-control">
                            </div>

                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="email" name="email" id="edit_email" class="form-control">
                            </div>

                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer supplier-modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary" form="editSupplierForm">
                            Update
                        </button>
                    </div>

                </div>
            </div>
        </div>

        <form method="post" action="controllers/company_controller.php" id="toggleSupplierForm" style="display:none;">
            <input type="hidden" name="action" value="toggle_supplier">
            <input type="hidden" name="supplier_id" id="toggle_supplier_id">
            <input type="hidden" name="supplier_state" id="toggle_supplier_state">
        </form>







        <script>
            function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
        </script>

        <script>
$(document).on('click', '.editSupplierBtn', function () {

    $('#edit_supplier_id').val($(this).data('id'));
    $('#edit_supplier_name').val($(this).data('name'));
    $('#edit_contact_person').val($(this).data('contact'));
    $('#edit_phone').val($(this).data('phone'));
    $('#edit_email').val($(this).data('email'));

    $('#editSupplierModal').modal('show');
});
</script>
<script>
$(document).on('click', '.toggleSupplierBtn', function () {

    var supplierId   = $(this).data('id');
    var newState     = $(this).data('state');
    var supplierName = $(this).data('name');

    var actionText   = (newState == 1) ? 'Enable' : 'Disable';
    var confirmColor = (newState == 1) ? '#26B99A' : '#d9534f';

    Swal.fire({
        title: actionText + ' Supplier?',
        html: 'Are you sure you want to <b>' + actionText.toLowerCase() +
              '</b> supplier <b>' + supplierName + '</b>?',
        icon: 'warning',
        showCancelButton: true,
        reversebuttons: true,
        confirmButtonColor: confirmColor,
        cancelButtonColor: '#aaa',
        confirmButtonText: 'Yes, ' + actionText,
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            submitSupplierToggle(supplierId, newState);
        }
    });

});
</script>

<script>
function submitSupplierToggle(id, state) {
    $('#toggle_supplier_id').val(id);
    $('#toggle_supplier_state').val(state);
    $('#toggleSupplierForm').submit();
}
</script>



    </body>
</html>
