<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.png" type="image/ico" />

    <title>Powertex LTD - System Users</title>
    <?php include_once 'css_links.php'; ?>
</head>

<body class="nav-md">
    <div class="container body">
        <div class="main_container">

            <?php 
                include 'menu_finance.php'; 
                include_once 'model/users_model.php';  

                $users_model = new users_model();
                $users = $users_model->getAllSystemUsers(); // You may need to create this method

                
            ?>

            <!-- page content -->
            <div class="right_col" role="main">
                <div class="">
                    <div class="page-title">
                        <div class="title_left">
                            <h3><small>System Users</small></h3>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12 ">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                    <!-- Left side: Title -->
                                    <div>
                                        <h2 class="mb-0">Details</h2>
                                    </div>

                                    <!-- Center: Title -->
                                    <div class="text-center flex-grow-1">
                                        <h5 class="mb-0">List of All System Users</h5>
                                    </div>

                                    <!-- Right side: Buttons -->
                                    <ul class="nav navbar-right panel_toolbox mb-0 d-flex align-items-center" style="gap: 10px;">
                                        <li>
                                            <a href="new_user.php" rel="facebox">
                                                <button class="btn btn-info btn-sm">Add New User <i class="fa fa-plus-circle"></i></button> 
                                            </a>
                                        </li>
                                        <li>
                                            <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                            </button>
                                        </li>
                                    </ul>
                                </div>

                                <div class="clearfix"></div>

                                <div class="x_content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card-box table-responsive">                                                          
                                                <?php if (!empty($users)) { ?>
                                                    <table class="table table-striped jambo_table bulk_action">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Name</th>
                                                                <th>Username</th>
                                                                <th>Email</th>
                                                                <th>Role</th>
                                                                <th>Location</th>
                                                                <th>User State</th>
                                                                <th style="width:10%;">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($users as $index => $user) { ?>
                                                                <tr>
                                                                    <td><?= $index + 1 ?></td>
                                                                    <td><?= htmlspecialchars($user['fullname']) ?></td>
                                                                    <td><?= htmlspecialchars($user['username']) ?></td>
                                                                    <td><?= htmlspecialchars($user['email_address']) ?></td>
                                                                    <td><?= htmlspecialchars($user['role']) ?></td>
                                                                    <td><?= htmlspecialchars($user['location_name']) ?></td>
                                                                    <td class="<?= $user['user_state'] == 1 ? 'bg-success text-white' : 'bg-danger text-white' ?>">
                                                                        <?= $user['user_state'] == 1 ? 'Active' : 'Inactive' ?>
                                                                    </td>
                                                                    <td style="text-align: center;">
                                                                        <div class="btn-toolbar justify-content-center" role="toolbar" aria-label="User Actions">
                                                                            <!-- Reset Password Button -->
                                                                            <div class="btn-group mr-1" role="group">
                                                                                <button title="Reset Password" class="btn btn-info btn-sm"
                                                                                    onclick="<?= $user['user_state'] == 1 
                                                                                        ? "resetPassword('{$user['username']}', '{$user['fullname']}', '{$user['role']}', '{$user['employee_code']}')" 
                                                                                        : "showDisabledMessage('{$user['username']}')" ?>">
                                                                                    <i class="fa fa-unlock"></i>
                                                                                </button>
                                                                            </div>


                                                                            <!-- Enable/Disable Button -->
                                                                            <div class="btn-group mr-1" role="group">
                                                                                <?php if ($user['user_state'] == 1): ?>
                                                                                    <button title="Disable Account" class="btn btn-danger btn-sm"
                                                                                        onclick="confirmDisable('<?= htmlspecialchars($user['fullname'], ENT_QUOTES) ?>', '<?= $user['role'] ?>', '<?= $user['username']?>')">
                                                                                        <i class="fa fa-user-slash"></i>
                                                                                    </button>
                                                                                <?php else: ?>
                                                                                    <button title="Enable Account" class="btn btn-success btn-sm"
                                                                                        onclick="confirmEnable('<?= $user['fullname'] ?>', '<?= $user['role'] ?>', '<?= $user['username']?>')">
                                                                                        <i class="fa fa-user-check"></i>
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                            </div>

                                                                            <!-- Dropdown Group -->
                                                                            <div class="btn-group" role="group">
                                                                                <button type="button" class="btn btn-info btn-sm dropdown-toggle" data-toggle="dropdown" title="More Actions">
                                                                                    <i class="fa fa-cog"></i>
                                                                                </button>
                                                                                <div class="dropdown-menu">
                                                                                    <?php if ($user['user_state'] == 1): ?>
                                                                                        <a class="dropdown-item" href="javascript:void(0);" onclick="updateRole('<?= $user['fullname'] ?>', '<?= $user['role'] ?>', '<?= $user['username'] ?>')">
                                                                                            Update Role
                                                                                        </a>
                                                                                        <a class="dropdown-item" href="javascript:void(0);" onclick="changeLocation(
                                                                                            '<?= addslashes($user['fullname']) ?>',
                                                                                            '<?= addslashes($user['employee_code']) ?>',
                                                                                            '<?= addslashes($user['location_name']) ?>',
                                                                                            '<?= addslashes($user['username']) ?>',
                                                                                            '<?= addslashes($user['role']) ?>')">
                                                                                            Change Location
                                                                                        </a>
                                                                                    <?php else: ?>
                                                                                        <a class="dropdown-item text-muted" href="javascript:void(0);" onclick="showDisabledMessage('<?= $user['fullname'] ?>')">
                                                                                            Update Role
                                                                                        </a>
                                                                                        <a class="dropdown-item text-muted" href="javascript:void(0);" onclick="showDisabledMessage('<?= $user['fullname'] ?>')">
                                                                                            Change Location
                                                                                        </a>
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </td>

                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                    </table>
                                                <?php } else { ?>
                                                    <div class="alert alert-info">No active system users found.</div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /page content -->

            <?php include_once 'footer.php'; ?>
        </div>
    </div>

    <?php include_once 'libraries.php'; ?>
    <script>
        function resetPassword(username, fullname, role, empCode) {
            Swal.fire({
                title: 'Reset Password',
                html: `Are you sure you want to reset password for <br><strong>${fullname}&nbsp;**Role - ${role}</strong>?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Reset',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#17a2b8', // Bootstrap info color (blue)
                cancelButtonColor: '#6c757d'   // Bootstrap gray
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = `reset_password.php?username=${encodeURIComponent(username)}&employee_code=${encodeURIComponent(empCode)}`;
                }
            });
        }


        function confirmDisable(fullname, role, username) {
            Swal.fire({
                title: 'Disable User Account',
                html: `Are you sure you want to <strong>disable</strong> the account for<br> <strong>${fullname}</strong> Role - ${role} ?<br>This will revoke their access to the system.`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Disable',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#dc3545',  // Bootstrap's red
                cancelButtonColor: '#6c757d'    // Bootstrap's gray
            }).then((result) => {
                if (result.isConfirmed) {
                    // Pass userstate=0 for disabling the user
                    window.location.href = `update_user_state.php?username=${encodeURIComponent(username)}&userstate=0`;
                }
            });
        }


        function confirmEnable(fullname, role, username) {
            Swal.fire({
                title: 'Re-enable User Account',
                html: `Are you sure you want to <strong>re-enable</strong> the account for <br><strong>${fullname}</strong> Role - ${role} ?<br>This will restore their access to the system.`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Re-enable',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#6c757d'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Pass userstate=1 for enabling the user
                    window.location.href = `update_user_state.php?username=${encodeURIComponent(username)}&userstate=1`;
                }
            });
        }

        function updateRole(fullname, role, username) {
            Swal.fire({
                title: 'Update User Role',
                html: `Are you sure you want to <strong>change</strong> the role for <br><strong>${fullname}</strong>? - Current Role: <strong>${role}</strong>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Change',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#6c757d'
            }).then((result) => {
                if (result.isConfirmed) {
                    const url = `update_user_role.php?username=${encodeURIComponent(username)}&userrole=${encodeURIComponent(role)}`;

                    // Use facebox directly on the URL
                    $.facebox.settings.loadingImage = 'facebox/loading.gif'; // Optional: your loading path
                    $.facebox.settings.closeImage = 'facebox/closelabel.png'; // Optional: your close icon path
                    $.facebox({ ajax: url }); // Open via ajax in modal
                }
            });
        }

        function changeLocation(fullname, employee_code, location, username, role) {
            Swal.fire({
                title: 'Change Location',
                html: `Are you sure you want to <strong>change</strong> location for <br><strong>${fullname}</strong>?<br>Current Location: <strong>${location}</strong>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Change',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#6c757d'
            }).then((result) => {
                if (result.isConfirmed) {
                    const url = `change_supman_location.php?employee_code=${encodeURIComponent(employee_code)}&username=${encodeURIComponent(username)}`;

                    $.facebox.settings.loadingImage = 'facebox/loading.gif';
                    $.facebox.settings.closeImage = 'facebox/closelabel.png';
                    $.facebox({ ajax: url });
                }
            });
        }

        
        function showDisabledMessage(username) {
            toastr.options = {
                closeButton: true,
                progressBar: true,
                timeOut: 5000,
                positionClass: 'toast-top-right'
            };

            toastr.warning(
                `Cannot update account<br> user account is currently disabled.`,
                `Action Not Allowed`
            );
        }


    </script>

    
</body>
</html>
