<?php
// p.php
$code = $_GET['c'] ?? null;

if (!$code) {
    die('Invalid link.');
}

$tmpFile = __DIR__ . '/supervisor/pdf/tmp/links.json';

if (!file_exists($tmpFile)) {
    die('File not found.');
}

// Read JSON lines and search for code
$lines = file($tmpFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$found = null;
foreach ($lines as $line) {
    $data = json_decode($line, true);
    if (isset($data['code']) && $data['code'] === $code) {
        $found = $data;
        break;
    }
}

if (!$found) {
    die('Invalid code.');
}

$filePath = __DIR__ . '/supervisor/pdf/generated/' . $found['file'];

if (!file_exists($filePath)) {
    die('File not found.');
}

// Serve file for download
header('Content-Description: File Transfer');
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));
readfile($filePath);
exit;
