<?php
header('Content-Type: application/json');
include_once 'model/stock_model.php';

$stock_model = new stock_model();

$tn_number = $_POST['tn_number'] ?? '';
$received_qty = $_POST['received_qty'] ?? [];
$reasons = $_POST['reason'] ?? [];

if (empty($tn_number) || empty($received_qty)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request data']);
    exit;
}

$updates = [];
foreach ($received_qty as $itemId => $qty) {
    $qty = floatval($qty);
    $reason = trim($reasons[$itemId] ?? '');

    // Get original qty from DB
    $original = $stock_model->getDeliveryNoteItemQty($itemId); // implement if not done

    // Check for difference and require reason
    if ($qty != $original && empty($reason)) {
        echo json_encode([
            'status' => 'error', 
            'message' => 'Reason is required for item ID ' . $itemId
        ]);
        exit;
    }

    $updates[] = [
        'item_id' => $itemId,
        'received_qty' => $qty,
        'reason' => $reason
    ];
}

// Save updates in database
$result = $stock_model->updateAdjustedStock($tn_number, $updates);

if ($result) {
    echo json_encode(['status' => 'success', 'message' => 'Transfer Note updated successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save adjustments']);
}
exit;
