<?php 
  include('menu_supervisor.php');
  date_default_timezone_set('Africa/Blantyre');

  include_once 'model/stock_model.php';
  include_once 'model/finance_model.php';
  include_once 'model/users_model.php';

  $stock_model = new stock_model();
  $finance_model = new finance_model();
  $users_model = new users_model();

  $salesData = $finance_model->getSalesData($location, 'monthly');
  $monthly_sales = $salesData['invoice_sales'] + $salesData['cash_sales'];
  $monthly_payments = $salesData['total_payments'];
  $open_invoices = $finance_model->countOpenInvoices($location, $employee_code);
  $num_active_quotations = $finance_model->countActiveQuotations($location, $employee_code);
  $total_outstanding = $finance_model->getTotalOutstandingInvoices($location);

  $num_products = $stock_model->countProducts($location);
  $num_transfers_in = $stock_model->countTransfersin($location);
  $num_transfers_out = $stock_model->countTransfersout($location);
?>
<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title>Dashboard</title>
      <link rel="apple-touch-icon" sizes="76x76" href="../finance/images/favicon.png">
      <link rel="icon" type="image/png" href="../finance/images/favicon.png">
      <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
      <style>
        #salesTable,
        #paymentsTable {
            width: 100% !important;
        }

      </style>

      
    </head>
    <body class="hold-transition sidebar-mini layout-fixed">
      <div class="content-wrapper">
        <section class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo number_format($monthly_sales,2);
                      ?>  
                    </h3>
                    <p>Monthly Sales</p>
                  </div>
                  <div class="icon">
                    <i class="fa fa-money-bill"></i>
                  </div>
                  <?php if($cashtr_permission == 1){ ?>
                    <a href="sales.php?range=monthly" class="small-box-footer">View Monthly Sales <i class="fas fa-arrow-circle-right"></i></a>
                  <?php }else{  ?>
                    <a onclick="refuse('Financial')" class="small-box-footer">View Monthly Sales <i class="fas fa-arrow-circle-right"></i></a>
                  <?php } ?>
                </div>
              </div>
            
              

              <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo number_format($monthly_payments,2)
                      ?> 
                    </h3>

                    <p>Monthly Payments</p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-receipt"></i>
                  </div>
                  <?php if($cashtr_permission == 1){ ?>
                    <a href="payments.php?range=monthly" class="small-box-footer">View Monthly Payments <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Financial')" class="small-box-footer">View Monthly Payments <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>
           
              <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>
                            <?php echo $open_invoices; ?> - K<?php echo number_format($total_outstanding, 2); ?>
                        </h3>
                        <p>Open Invoices</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-file-invoice"></i>
                    </div>
                    <?php if($cashtr_permission == 1){ ?>
                        <a href="open_invoices.php" class="small-box-footer">
                            View Invoices <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    <?php } else { ?>
                        <a onclick="refuse('Financial')" class="small-box-footer">
                            View Invoices <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    <?php } ?>
                </div>
              </div>


              <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo $num_active_quotations;
                      ?>
                    </h3>
                    <p>Active Quotations</p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-file-invoice"></i>
                  </div>
                  <?php if($cashtr_permission== 1){ ?>
                    <a href="active_quotations.php" class="small-box-footer">View Quotations <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Financial')" class="small-box-footer">View Quotations <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>

              
            </div>

            <div class="row">
              <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo $num_products;
                      ?> 
                    </h3>
                    <p>Manage Products</p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-cubes"></i>
                  </div>
                  <?php if($stocki_permission == 1){ ?>
                    <a href="manage_products.php" class="small-box-footer">Manage Products <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Stock')" class="small-box-footer">Manage Products <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>

              <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo $num_products;
                      ?> 
                    </h3>
                    <p>Stock Sheets</p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-file-alt"></i>
                  </div>
                  <?php if($stocki_permission == 1){ ?>
                    <a href="stock_sheets.php" class="small-box-footer">View Stock Sheets <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Stock')" class="small-box-footer">View Stock Sheets <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>

              <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo $num_transfers_in;
                      ?> 
                    </h3>
                    <p>Stock Transfers(IN) </p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-exchange-alt"></i>

                  </div>
                  <?php if($stocki_permission == 1){ ?>
                    <a href="stock_transfers.php?type=in" class="small-box-footer">Manage Transfers <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Stock')" class="small-box-footer">Manage Transfers <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>
              
              <div class="col-lg-3 col-6">
                <div class="small-box bg-danger">
                  <div class="inner">
                    <h3>
                      <?php 
                        echo $num_transfers_out;
                      ?> 
                    </h3>
                    <p>Stock Transfers(OUT) </p>
                  </div>
                  <div class="icon">
                    <i class="fas fa-exchange-alt"></i>

                  </div>
                  <?php if($stocki_permission == 1){ ?>
                    <a href="stock_transfers.php?type=out" class="small-box-footer">Manage Transfers <i class="fas fa-arrow-circle-right"></i></a>
                    <?php }else{  ?>
                      <a onclick="refuse('Stock')" class="small-box-footer">Manage Transfers <i class="fas fa-arrow-circle-right"></i></a>
                    <?php } ?>
                </div>
              </div>
            </div>

            <div class="row align-items-center mb-3">
              <div class="col-md-6">
                  <h4 class="mb-0 font-weight-bold">
                      Sales Overview
                  </h4>
              </div>

              <div class="col-md-6 text-right">
                  <?php 
                    if($salesDisplay ==1){ ?> 
                      <button class="btn btn-danger" id="toggleSales" data-current="<?= $salesDisplay ?>">
                          Hide Sales <i class="fa fa-eye-slash"></i>
                      </button>
                    <?php
                    }else{ ?>
                      <button class="btn btn-success" id="toggleSales" data-current="<?= $salesDisplay ?>">
                          Show Sales <i class="fa fa-eye"></i>
                      </button>
                    <?php
                      } 
                    ?>
                  <?php 
                    if($paymentsDisplay ==1){ ?> 
                      <button class="btn btn-danger" id="togglePayments" data-current="<?= $paymentsDisplay ?>">
                          Hide Payments <i class="fa fa-eye-slash"></i>
                      </button>
                    <?php
                    }else{ ?>
                      <button class="btn btn-success" id="togglePayments" data-current="<?= $paymentsDisplay ?>">
                          Show Payments <i class="fa fa-eye"></i>
                      </button>
                    <?php
                      } 
                    ?>

                  <button type="button" class="btn btn-default ml-2" id="dashboardDateRange">
                      <i class="far fa-calendar-alt"></i>&nbsp;
                      <span></span>
                      <i class="fas fa-caret-down ml-1"></i>
                  </button>
              </div>
            </div>



            <div class="row mt-4">
              <div class="col-12" id="salesSection" style="display: <?= $salesDisplaySetting ?>;">
                <div style="display: <?= $salesDisplaySetting ?>;">
                  <div class="card card-primary card-outline">
                    <div class="card-header d-flex align-items-center">
                        <h3 class="card-title mb-0">Sales Transactions</h3>

                        <div class="ml-auto">
                            <button type="button" class="btn btn-success" id="exportSalesExcel">
                                Export to Excel <i class="fas fa-file-excel"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body table-responsive" id="salesTableContainer">
                      <table class="table table-bordered table-striped" id="salesTable">
                        <thead>
                          <tr>
                            <th>Date</th>
                            <th>Transaction ID</th>
                            <th>Customer</th>
                            <th>Sales Location</th>
                            <th>Transaction Type</th>
                            <th>Sales Amount</th>
                            <th>Total Paid</th>
                            <th>Balance</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          
                        </tbody>
                        <tfoot class="bg-secondary" style="background:#f4f6f9;font-weight:bold"></tfoot>
                      </table>
                    </div>
                  </div>
                </div>
              </div>

                <!-- Payments Table -->
              
              <div class="col-12 mt-4" id="paymentsSection">
                <div style="display: <?= $paymentsDisplaySetting ?>;">
                  <div class="card card-info card-outline">
                    <div class="card-header d-flex align-items-center">
                        <h3 class="card-title mb-0">Payments</h3>

                        <div class="ml-auto">


                            <button type="button" class="btn btn-success" id="exportPaymentsExcel">
                                Export to Excel <i class="fas fa-file-excel"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body table-responsive" id="paymentsTableContainer">
                      <table class="table table-bordered table-striped" id="paymentsTable">
                        <thead>
                          <tr>
                            <th>Date</th>
                            <th>Payment Method</th>
                            <th>Transaction ID</th>
                            <th>Customer</th>
                            <th>Location</th>
                            <th>Transaction Type</th>
                            <th>Amount Paid</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          
                        </tbody>
                        <tfoot class="bg-secondary" style="background:#f4f6f9;font-weight:bold"></tfoot>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          
            <div class="row mt-4">
              <div class="col-12" id="chartSection">
                <div class="card card-outline card-secondary">
                  <div class="card-header">
                    <h3 class="card-title">Sales & Payments Overview</h3>
                  </div>
                  <div class="card-body" style="height:450px">
                    <canvas id="salesPaymentsChart"></canvas>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
      <aside class="control-sidebar control-sidebar-dark"></aside>
      <script src="../includes/plugins/jquery/jquery.min.js"></script>
      <script src="../includes/plugins/jquery-ui/jquery-ui.min.js"></script>
      <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
      <script src="../includes/dist/js/adminlte.js"></script> 
      <script src="../includes/js/script.js"></script>
      <script src="../includes/plugins/jquery/jquery.min.js"></script>
      <script src="../includes/plugins/chart.js/Chart.min.js"></script>
      <script src="../includes/plugins/moment/moment.min.js"></script>
      <script src="../includes/plugins/daterangepicker/daterangepicker.js"></script>
      <script>
        $(function () {
          let CURRENT_START_DATE = null;
          let CURRENT_END_DATE   = null;

          let start = moment().startOf('day');
          let end   = moment().endOf('day');

          function updateDateRange(start, end) {
            CURRENT_START_DATE = start.format('YYYY-MM-DD');
            CURRENT_END_DATE   = end.format('YYYY-MM-DD');

            $('#dashboardDateRange span').html(
                start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY')
            );

            fetchTransactions(CURRENT_START_DATE, CURRENT_END_DATE);
          }
           

        $('#exportSalesExcel').on('click', function () {
            window.location.href =
                `exports/export_sales_excel.php?start=${CURRENT_START_DATE}&end=${CURRENT_END_DATE}&location=<?= $location ?>`;
        });


        

        $('#exportPaymentsExcel').on('click', function () {
            window.location.href =
                `exports/export_payments_excel.php?start=${CURRENT_START_DATE}&end=${CURRENT_END_DATE}&location=<?= $location ?>`;
        });


          $('#dashboardDateRange').daterangepicker({
            startDate: start,
            endDate: end,
            opens: 'left',
            autoApply: true,
            ranges: {
              'Today': [moment(), moment()],
              'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
              'This Week': [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
              'Last Week': [moment().subtract(1, 'week').startOf('isoWeek'), moment().subtract(1, 'week').endOf('isoWeek')],
              'Last 7 Days': [moment().subtract(6, 'days'), moment()],
              'Last 30 Days': [moment().subtract(29, 'days'), moment()],
              'This Month': [moment().startOf('month'), moment().endOf('month')],
              'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
              'Year to Date': [moment().startOf('year'), moment()]
            },
            locale: {
              format: 'YYYY-MM-DD'
            }
          }, updateDateRange);

          updateDateRange(start, end);

          function fetchTransactions(startDate, endDate) {
              $.ajax({
                  url: 'dashboard_sales.php',
                  type: 'GET',
                  data: {
                      start: startDate,
                      end: endDate,
                      location: <?php echo $location ?>
                  },
                  dataType: 'json',
                  success: function(response) {
                      const startFormatted = moment(startDate).format('MMMM D, YYYY');
                      const endFormatted   = moment(endDate).format('MMMM D, YYYY');

                      // --- SALES TABLE ---
                      if (response.sales && response.sales.length > 0) {
                          $('#salesSection').show();  // show the table container
                          $('#salesTable thead, #salesTable tfoot').show();

                          let salesBody = '';
                          let totalAmount = 0, totalPaid = 0, totalBalance = 0;

                          response.sales.forEach(function(sale) {
                              let link = sale.sale_type === 'Cash Sale' 
                                  ? `cash_sale_receipt.php?id=${encodeURIComponent(sale.reference)}`
                                  : `customer_invoice.php?invoice_number=${encodeURIComponent(sale.reference)}`;
                              
                              salesBody += `
                                  <tr>
                                      <td>${sale.date}</td>
                                      <td>${sale.reference}</td>
                                      <td>${sale.customer}</td>
                                      <td>${sale.location}</td>
                                      <td>${sale.sale_type}</td>
                                      <td style="text-align:right">${formatNumber(sale.amount)}</td>
                                      <td style="text-align:right">${formatNumber(sale.paid)}</td>
                                      <td style="text-align:right">${formatNumber(sale.balance)}</td>
                                      <td>
                                          <a class="btn btn-info btn-sm text-white" href="${link}">View Details</a>
                                      </td> 
                                  </tr>`;

                              totalAmount  += parseFloat(sale.amount) || 0;
                              totalPaid    += parseFloat(sale.paid) || 0;
                              totalBalance += parseFloat(sale.balance) || 0;
                          });

                          $('#salesTable tbody').html(salesBody);
                          $('#salesTable tfoot').html(`
                              <tr>
                                  <th colspan="5" style="text-align:left">TOTAL</th>
                                  <th style="text-align:right">${formatNumber(totalAmount)}</th>
                                  <th style="text-align:right">${formatNumber(totalPaid)}</th>
                                  <th style="text-align:right">${formatNumber(totalBalance)}</th>
                                  <th></th>
                              </tr>
                          `);
                      } else {
                          // hide sales table entirely
                          $('#salesSection').hide();
                      }

                      // --- PAYMENTS TABLE ---
                      if (response.payments && response.payments.length > 0) {
                          $('#paymentsSection').show(); // show the table container
                          $('#paymentsTable thead, #paymentsTable tfoot').show();

                          let paymentsBody = '';
                          let totalPayments = 0;

                          response.payments.forEach(function(pay) {
                              let link = pay.type === 'Cash Sale' 
                                  ? `cash_sale_receipt.php?id=${encodeURIComponent(pay.transaction_number)}`
                                  : `invoice_payment_receipt.php?receipt_number=${encodeURIComponent(pay.receipt_number)}`;

                              paymentsBody += `
                                  <tr>
                                      <td>${pay.date}</td>
                                      <td>${pay.payment_method}</td>
                                      <td>${pay.transction_id}</td>
                                      <td>${pay.customer}</td>
                                      <td>${pay.location}</td>
                                      <td>${pay.type}</td>
                                      <td style="text-align:right">${formatNumber(pay.amount)}</td> 
                                      <td>
                                          <a class="btn btn-info btn-sm text-white" href="${link}">View Details</a>
                                      </td>
                                  </tr>`;

                              totalPayments += parseFloat(pay.amount) || 0;
                          });

                          $('#paymentsTable tbody').html(paymentsBody);
                          $('#paymentsTable tfoot').html(`
                              <tr>
                                  <th colspan="6" style="text-align:left">TOTAL</th>
                                  <th style="text-align:right">${formatNumber(totalPayments)}</th>
                                  <th></th>
                              </tr>
                          `);
                      } else {
                          // hide payments table entirely
                          $('#paymentsSection').hide();
                      }

                      // --- SALES & PAYMENTS CHART ---
                      if (response.chart && response.chart.data && response.chart.data.length > 0) {
                          $('#chartSection').parent().show(); // show chart container
                          renderChart(response.chart);
                      } else {
                          // hide chart container
                          $('#chartSection').parent().hide();
                      }

                      // --- OPTIONAL: show a central "No Data" message if everything is empty ---
                      if ((!response.sales || response.sales.length === 0) && 
                        (!response.payments || response.payments.length === 0) && 
                        (!response.chart || !response.chart.data || response.chart.data.length === 0)) {

                        // Create or update a placeholder below the tiles
                        if ($('#noDataMessage').length === 0) {
                            $('.container-fluid').append(`
                                <div id="noDataMessage" class="text-center text-muted my-5">
                                    <h4>No Sales or Payments found between ${startFormatted} and ${endFormatted}</h4>
                                </div>
                            `);
                        } else {
                            $('#noDataMessage').html(`<h4>No Sales or Payments found between ${startFormatted} and ${endFormatted}</h4>`);
                            $('#noDataMessage').show();
                        }
                    } else {
                        $('#noDataMessage').hide();
                    }

                  },
                  error: function(err) {
                      console.error(err);
                  }
              });
          }


          function formatNumber(value) {
            if (value === null || value === undefined || value === '') return '0.00';
            return new Intl.NumberFormat('en-US', {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2
            }).format(parseFloat(value));
          }

          $('#togglePayments').on('click', function () {
            const current = parseInt($(this).data('current'));
            const next = current === 1 ? 0 : 1;

            $.post('controllers/settings_controller.php', {
              action: 'update_display_setting',
              column: 'payments_display',
              value: next
            }, function () {
              location.reload();
            });
          });

          $('#toggleSales').on('click', function () {
            const current = parseInt($(this).data('current'));
            const next = current === 1 ? 0 : 1;

            $.post('controllers/settings_controller.php', {
              action: 'update_display_setting',
              column: 'sales_display',
              value: next
              }, function () {
                location.reload(); // reload to respect DB state
            });
          });

          let salesPaymentsChart = null;

function renderChart(chartData) {
    if (!chartData || !chartData.data || !chartData.data.length) {
        console.warn('No chart data to render');
        return;
    }

    const labels   = [];
    const sales    = [];
    const payments = [];

    let totalSales = 0;
    let totalPayments = 0;

    chartData.data.forEach(row => {
        labels.push(row.label);
        const saleVal = parseFloat(row.sales) || 0;
        const payVal  = parseFloat(row.payments) || 0;
        sales.push(saleVal);
        payments.push(payVal);

        totalSales += saleVal;
        totalPayments += payVal;
    });

    const ctx = document.getElementById('salesPaymentsChart').getContext('2d');

    if (salesPaymentsChart) {
        salesPaymentsChart.destroy();
    }

    salesPaymentsChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [
                {
                    label: `Sales (Total: ${formatNumber(totalSales)})`,
                    type: 'bar',
                    data: sales,
                    backgroundColor: 'rgba(54, 162, 235, 0.75)'
                },
                {
                    label: `Payments (Total: ${formatNumber(totalPayments)})`,
                    type: 'bar',
                    data: payments,
                    backgroundColor: 'rgba(40, 167, 69, 0.75)'
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'top',
                labels: {
                    fontSize: 14,
                    fontStyle: 'bold'
                }
            },
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        callback: function (value) {
                            return new Intl.NumberFormat('en-US').format(value);
                        }
                    }
                }],
                xAxes: [{
                    gridLines: { display: false }
                }]
            },
            tooltips: {
                mode: 'index',
                intersect: false,
                callbacks: {
                    label: function (tooltipItem, data) {
                        return data.datasets[tooltipItem.datasetIndex].label.split(' (')[0] + ': ' +
                        new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(tooltipItem.yLabel);
                    }
                }
            }
        }
    });
}

        });
      </script>
      <script>
        function refuse(Role) {
          toastr.options = {
            "closeButton": true,
            "progressBar": false,
            "positionClass": "toast-top-right",  // You can change the position as needed
            "timeOut": "5000",                   // 5 seconds
            "extendedTimeOut": "3000"            // Extended time before it fades out
          };
          toastr.error(`You don't have permission to view ${Role} Transactions.`, "Permission Denied");
        }
      </script>
    </body>
  </html>
