<?php 
    include('menu_supervisor.php');
    include_once 'model/stock_model.php';
    include_once 'model/warehouse_model.php';
    include_once 'model/branch_model.php';

    $stock_model = new stock_model();
    $warehouse_model = new warehouse_model();
    $branch_model = new branch_model();

    if(isset($_GET['tn_number'])){
        $tn_number = $_GET['tn_number'];
    }else{
        $_SESSION['notification']=[
            'type' => 'error',
            'title' => 'FALIED',
            'message'=> 'Failed To initiate Transfer'
        ];
        
        exit;
    }

    $products = $stock_model->getproducts($location); 
    $warehouseDetails = $warehouse_model->getWarehouseDetails($location);
?>
<!DOCTYPE html>
    <html lang="en">
        <head>

            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Powertex || Initiate Stock Transfer</title>

            <link rel="icon" type="image/png" href="../finance/images/favicon.png">
            <style>
                #transferForm .form-control,
                #transferForm .btn {
                    height: 40px;
                }
                #transferForm label {
                    font-weight: 600;
                    margin-bottom: 4px;
                }
            </style>

        </head>

        <body class="hold-transition sidebar-mini layout-fixed">

            <div class="content-wrapper p-4">

                <div class="row mb-3">
                    <div class="col-12">
                        <h4 class="mb-0 font-weight-bold">Initiate Stock Transfer</h4>
                        <hr>
                    </div>
                </div>

                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Transfer Details</h3>
                    </div>

                    <div class="card-body">

                        <!-- NOTE: This form is used for client-side interactions. Adding items uses AJAX to controllers/transfer_controller.php -->
                        <form id="transferForm" autocomplete="off">

                            <!-- ADD THIS BLOCK -->
                            <div class="form-row">

                                <div class="form-group col-md-3">
                                    <label>Transfer Note No.</label>
                                    <input type="text" class="form-control" value="<?= $tn_number ?>" readonly>
                                    <input type="hidden" name="tn_number" value="<?= $tn_number ?>">
                                </div>

                            </div>
                            <!-- END ADD BLOCK -->


                            <!-- ROW 1 -->
                            <div class="form-row">

                                <div class="form-group col-md-2">
                                    <label>From Warehouse</label>
                                    <input type="text" class="form-control" id="fromWarehouseName"
                                        value="<?= htmlspecialchars($warehouseDetails['warehouse_name']) ?>" readonly>

                                    <input type="hidden" id="fromWarehouseId" name="warehouse_id"
                                        value="<?= htmlspecialchars($location) ?>" readonly>

                                    <input type="hidden" name="action" value="add_item">
                                </div>

                                <div class="form-group col-md-2">
                                    <label>Product</label>
                                    <select class="form-control" id="productSelect" required>
                                        <option value="">-- Select Product --</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-2">
                                    <label>Remaining</label>
                                    <input type="text" class="form-control" id="quantityRemaining" readonly>
                                </div>

                                <div class="form-group col-md-2">
                                    <label>Qty</label>
                                    <input type="number" class="form-control" id="qtyInput" min="1" step="0.001" required>
                                </div>

                                <div class="form-group col-md-4">
                                    <label>Transfer Date</label>
                                    <input type="date" max="<?= date('Y-m-d') ?>" id="transferDate"
                                        class="form-control" value="<?= date('Y-m-d') ?>" required>
                                </div>

                            </div>

                            <!-- ROW 2 -->
                            <div class="form-row">

                                <div class="form-group col-md">
                                    <label>Destination Type</label>
                                    <select class="form-control" id="destinationType">
                                        <option value="">-- Select Type --</option>
                                        <option value="warehouse">Warehouse</option>
                                        <option value="branch">Branch</option>
                                    </select>
                                </div>

                                <div class="form-group col-md">
                                    <label>Destination</label>
                                    <select class="form-control" id="toLocation" disabled>
                                        <option value="">-- Select Destination --</option>
                                    </select>
                                </div>

                                <div class="form-group col-md d-flex align-items-end">
                                    <button type="button" class="btn btn-success btn-block" id="addItem">
                                        <i class="fas fa-plus"></i> Add Item
                                    </button>
                                </div>

                            </div>

                        </form>
                    </div>
                </div>

                <!-- TABLE OF ITEMS -->
                <div class="card mt-3">
                    <div class="card-header bg-dark">
                        <h3 class="card-title">Items to Transfer</h3>
                    </div>

                    <div id="itemsWrapper">

                        <!-- Initially a dummy row; after actions server will return fresh HTML for this table -->
                        <table class="table table-bordered table-striped" id="itemsTable">
                            <thead class="thead-dark">
                            <tr>
                                <th style="width: 8%">Action</th>
                                <th style="width: 10%">Date</th>
                                <th>Product</th>
                                <th style="width: 15%">From</th>
                                <th style="width: 15%">Destination</th>
                                <th style="width: 12%">Qty</th>
                            </tr>
                            </thead>

                            <tbody id="itemsBody">
                                <tr>
                                    <td colspan="6" class="text-center text-muted">No items yet. Add items to begin.</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>

                <!-- Finalize transfer button -->
                <div class="row mt-3">
                    <div class="col text-right d-flex justify-content-end align-items-center">
                        <input type="text" name="driver" 
                            class="form-control mr-2" 
                            style="width: 250px;" 
                            placeholder="Driver Name" required>

                        <button id="finalizeBtn" class="btn btn-success" disabled>
                            <i class="fa fa-check-circle"></i> Complete Transfer
                        </button>
                    </div>
                </div>


            </div>

            <!-- Modals container (dynamically generated when server returns items with modals or when we render) -->
            <div id="modalsContainer">


            </div>

            <!-- jQuery + Bootstrap + AdminLTE + SweetAlert2 -->
            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/dist/js/adminlte.js"></script>
            <script src="../includes/plugins/sweetalert2/sweetalert2.all.min.js"></script>

            <script>
                (function () {
                    const tnNumber = "<?= isset($tn_number) ? htmlspecialchars($tn_number) : '' ?>";
                    console.log('TN Number:', tnNumber);

                    const fromWarehouseId = document.getElementById('fromWarehouseId').value;
                    const productSelect = document.getElementById('productSelect');
                    const qtyInput = document.getElementById('qtyInput');
                    const addItemBtn = document.getElementById('addItem');
                    const quantityRemaining = document.getElementById('quantityRemaining');
                    const toLocation = document.getElementById('toLocation');
                    const transferDate = document.getElementById('transferDate');
                    const itemsBody = document.getElementById('itemsBody');
                    const itemsWrapper = document.getElementById('itemsWrapper');
                    const modalsContainer = document.getElementById('modalsContainer');
                    const finalizeBtn = document.getElementById('finalizeBtn');

                    let destinationError = false;

                    // Utility: show toast on top-right using Swal
                    function toastSuccess(message) {
                        Swal.fire({ position: 'top-end', icon: 'success', title: message, showConfirmButton: false, timer: 1400 });
                    }
                    function toastError(message) {
                        Swal.fire({ position: 'top-end', icon: 'error', title: message, showConfirmButton: false, timer: 1800 });
                    }

                    // 1) On load, auto-load products for the fromWarehouse using same endpoint name as reference:
                    //    fetch_products.php?company_id=<fromWarehouseId>
                    function loadProducts() {
                        productSelect.innerHTML = '<option>Loading...</option>';
                        fetch(`fetch_products.php?warehouse_id=${encodeURIComponent(fromWarehouseId)}`)
                            .then(r => r.json())
                            .then(data => {
                                productSelect.innerHTML = '<option value="">-- Select Product --</option>';
                                data.forEach(p => {
                                    // ensure product name safe
                                    const opt = document.createElement('option');
                                    opt.value = p.product_id;
                                    opt.textContent = p.product_name;
                                    opt.dataset.name = p.product_name;
                                    productSelect.appendChild(opt);
                                });
                            })
                            .catch(err => {
                                console.error('fetch_products error', err);
                                productSelect.innerHTML = '<option value="">-- Error loading products --</option>';
                            });     
                    }

                    // 2) When product changes, fetch remaining qty
                    productSelect.addEventListener('change', function () {
                        quantityRemaining.value = '';
                        resetRemainingStyle();
                        resetDestinationStyle();
                        const productId = this.value;
                        if (!productId) return;

                        fetch(`fetch_quantity.php?warehouse=${encodeURIComponent(fromWarehouseId)}&product_id=${encodeURIComponent(productId)}`)
                            .then(r => r.json())
                            .then(data => {
                                // expecting { quantity: "12.000" } or similar
                                const qty = parseFloat(data.quantity || 0);
                                quantityRemaining.value = qty.toFixed(2);

                                if (qty <= 0) {
                                    highlightRemainingDanger();
                                    addItemBtn.disabled = true;
                                } else {
                                    resetRemainingStyle();
                                    addItemBtn.disabled = false;
                                    // also validate destination if already chosen
                                    if (toLocation.value) validateDestinationProduct();
                                }
                            })
                            .catch(err => {
                                console.error('fetch_company_quantity error', err);
                                quantityRemaining.value = '';
                            });
                        }
                    );

                    // 3) Validate product exists at destination using:
                    //    check_destination_product.php?product_id=<>&destination_id=<>
                    toLocation.addEventListener('change', validateDestinationProduct);

                    function validateDestinationProduct() {
                        const productId = productSelect.value;
                        const destinationId = toLocation.value;
                        resetDestinationStyle();
                        destinationError = false;

                        if (!productId || !destinationId) {
                            // nothing to validate
                            addItemBtn.disabled = false;
                            return;
                        }

                        fetch(`check_destination_product.php?product_id=${encodeURIComponent(productId)}&destination_id=${encodeURIComponent(destinationId)}`)
                            .then(r => r.json())
                            .then(data => {
                                // expecting { exists: true } or { exists: false }
                                if (!data.exists) {
                                    destinationError = true;
                                    highlightDestinationError();
                                    addItemBtn.disabled = true;
                                } else {
                                    destinationError = false;
                                    resetDestinationStyle();
                                    // only re-enable if remaining > 0
                                    const rem = parseFloat(quantityRemaining.value || 0);
                                    addItemBtn.disabled = (rem <= 0);
                                }
                            })
                            .catch(err => {
                                console.error('check_destination_product error', err);
                            });
                    }

                    function highlightRemainingDanger() {
                        quantityRemaining.classList.add('border-danger', 'text-danger');
                        quantityRemaining.title = 'This product has zero stock and cannot be transferred.';
                    }
                    function resetRemainingStyle() {
                        quantityRemaining.classList.remove('border-danger', 'text-danger');
                        quantityRemaining.title = '';
                    }
                    function highlightDestinationError() {
                        toLocation.classList.add('border-danger');
                        toLocation.title = 'This product does not exist in the selected destination.';
                    }
                    function resetDestinationStyle() {
                        toLocation.classList.remove('border-danger');
                        toLocation.title = '';
                    }

                    // 4) Add item: mirror reference behavior — post to controllers/transfer_controller.php via fetch (POST).
                    //    The server should accept action=add_item and return JSON with a fresh HTML snippet for the items table
                    addItemBtn.addEventListener('click', function () {
                        const productId = productSelect.value;
                        const qty = qtyInput.value;
                        const destinationId = toLocation.value;
                        const date = transferDate.value;

                        if (!productId) { toastError('Select a product'); return; }
                        if (!destinationId) { toastError('Select a destination'); return; }
                        if (!qty || parseFloat(qty) <= 0) { toastError('Enter a valid quantity'); return; }

                        if (destinationError) { toastError('Invalid destination for this product'); return; }

                        // construct form data
                        const formData = new FormData();
                        formData.append('action', 'add_item'); // controller should handle this action
                        formData.append('tn_number', tnNumber);
                        formData.append('warehouse_id', fromWarehouseId);   
                        formData.append('product_id', productId);
                        formData.append('quantity', qty);
                        formData.append('destination', destinationId);
                        formData.append('transfer_date', date);
                        formData.append('remaining_quantity', quantityRemaining.value);


                        addItemBtn.disabled = true;
                        addItemBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Adding...';

                        fetch('controllers/transfer_controller.php', {
                            method: 'POST',
                            body: formData,
                            credentials: 'same-origin'
                        })
                        .then(r => r.json())
                        .then(resp => {
                            // Server conventions:
                            // Success: { success: true, html: "...table rows html...", modals: "..." , finalize_enabled: true/false, message: "..." }
                            // Failure: { success: false, message: "error text" }
                            if (!resp || !resp.success) {
                                throw new Error((resp && resp.message) ? resp.message : 'Server error adding item');
                            }

                            toastSuccess(resp.message || 'Item added');
                            setTimeout(() => location.reload(), 1000); // wait 0.10s for toast


                            // enable finalize if server says so
                            finalizeBtn.disabled = !resp.finalize_enabled;

                            // reset product & qty
                            productSelect.value = '';
                            qtyInput.value = '';
                            quantityRemaining.value = '';

                            toastSuccess(resp.message || 'Item added');

                        })
                        .catch(err => {
                            console.error('add_item error', err);
                            toastError(err.message || 'Failed to add item');
                        })
                        .finally(() => {
                            addItemBtn.disabled = false;
                            addItemBtn.innerHTML = '<i class="fas fa-plus"></i> Add Item';
                        });
                    });

                    // 5) Delegate delete/update actions from items table — we expect server-side forms/buttons to have classes/attributes we can catch.
                    //    We'll use event delegation to catch clicks on elements with data-action attributes (delete-item, edit-qty, edit-date, finalize)
                    itemsWrapper.addEventListener('click', function(ev) {
                        const target = ev.target.closest('[data-action="delete-item"]');
                        if (!target) return;

                        const itemId = target.dataset.itemId;
                        if (!itemId) return;

                        const product_id = target.dataset.product_id;
                        if(!product_id) return;

                        const warehouse_id = target.dataset.warehouse_id;
                        if(!warehouse_id) return;

                        const qty = target.dataset.qty;
                        if(!qty) return;

                        console.log('Warehouse:' + warehouse_id + 'Product:' + product_id + 'Quantity:' + qty);

                        Swal.fire({
                            title: 'Are you sure?',
                            text: "This item will be removed from the transfer list.",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, remove it!'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                const fd = new FormData();
                                fd.append('action', 'delete_item');
                                fd.append('item_id', itemId);
                                fd.append('product_id', product_id);
                                fd.append('warehouse_id', warehouse_id);
                                fd.append('qty', qty);
                                fd.append('tn_number', '<?= $tn_number ?>');

                                fetch('controllers/transfer_controller.php', { method: 'POST', body: fd, credentials: 'same-origin' })
                                    .then(r => r.json())
                                    .then(resp => {
                                        if (!resp || !resp.success) throw new Error((resp && resp.message) ? resp.message : 'Delete failed');

                                        Swal.fire('Deleted!', resp.message || 'Item removed', 'success')
                                            .then(() => {
                                                // reload the page to refresh items & modals
                                                location.reload();
                                            });
                                    })
                                    .catch(err => {
                                        console.error('delete_item error', err);
                                        Swal.fire('Error', err.message || 'Failed to delete item', 'error');
                                    });
                            }
                        });
                    });

                    function checkAndLockFields() {
                        const fd = new FormData();
                        fd.append('action', 'check_has_items');
                        fd.append('tn_number', tnNumber);

                        fetch('controllers/transfer_controller.php', { method: 'POST', body: fd })
                            .then(r => r.json())
                            .then(resp => {
                                const fromWarehouseInput = document.getElementById('fromWarehouseName');
                                const fromWarehouseIdInput = document.getElementById('fromWarehouseId');
                                const destinationTypeSelect = document.getElementById('destinationType');
                                const toLocationSelect = document.getElementById('toLocation');
                                const transferDateInput = document.getElementById('transferDate');

                                if (resp.success && resp.has_items) {
                                    // Lock fields
                                    fromWarehouseInput.readOnly = true;
                                    fromWarehouseIdInput.disabled = true;
                                    destinationTypeSelect.disabled = true;
                                    toLocationSelect.disabled = true;
                                    transferDateInput.disabled = true;

                                    // Pre-fill values
                                    if (resp.from_warehouse_name) fromWarehouseInput.value = resp.from_warehouse_name;
                                    if (resp.from_warehouse_id) fromWarehouseIdInput.value = resp.from_warehouse_id;

                                    if (resp.destination_type) destinationTypeSelect.value = resp.destination_type;

                                    if (resp.destination_type && resp.destination_id) {
                                        // populate destination select with single value
                                        toLocationSelect.innerHTML = `<option value="${resp.destination_id}" selected>${resp.destination_name}</option>`;
                                    }
                                } else {
                                    // Unlock destination
                                    fromWarehouseInput.readOnly = true; // always readonly
                                    fromWarehouseIdInput.disabled = true;
                                    destinationTypeSelect.disabled = false;
                                    toLocationSelect.disabled = false;
                                    transferDateInput.disabled = false;
                                }
                            })
                            .catch(err => console.error('check_has_items error', err));
                    }

                    // 6) Finalize transfer (button)
                    finalizeBtn.addEventListener('click', function () {

                        const driverInput = document.querySelector('input[name="driver"]');
                        const driverName = driverInput.value.trim();

                        const destinationId = document.getElementById('toLocation').value;

                        // ✅ DRIVER MUST BE ENTERED
                        if (driverName === "") {
                            toastError("Please enter driver name before finalizing.");
                            driverInput.focus();
                            return;
                        }

                        Swal.fire({
                            title: 'Complete transfer?',
                            text: "This will finalize the transfer and move items.",
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes, finalize',
                        }).then(result => {

                            if (!result.isConfirmed) return;

                            const fd = new FormData();
                            fd.append('action', 'finalize_transfer');
                            fd.append('transfer_id', tnNumber);      // ⭐ TN NUMBER
                            fd.append('driver', driverName);         // ⭐ DRIVER NAME
                            fd.append('from_warehouse', fromWarehouseId);
                            fd.append('destination_id', destinationId);

                            fetch('controllers/transfer_controller.php', {
                                method: 'POST',
                                body: fd,
                                credentials: 'same-origin'
                            })
                            .then(r => r.json())
                            .then(resp => {

                                if (!resp || !resp.success)
                                    throw new Error((resp && resp.message) ? resp.message : 'Finalize failed');

                                toastSuccess(resp.message || 'Transfer completed');

                                // ⭐ ALWAYS REDIRECT AFTER SUCCESS
                                window.location.href = `transfer_note.php?id=${tnNumber}&transfer_to=${destinationId}`;

                            })
                            .catch(err => {
                                console.error('finalize_transfer error', err);
                                toastError(err.message || 'Failed to finalize transfer');
                            });

                        });
                    });



                    // 7) On page load: populate products and also attempt to load existing items table (if any)
                    function loadExistingItems() {
                        // ask controller for current items for this transfer (action=get_items)
                        const fd = new FormData();
                        fd.append('action', 'get_items');
                        fd.append('tn_number', tnNumber); // pass TN number

                        fetch('controllers/transfer_controller.php', { method: 'POST', body: fd, credentials: 'same-origin' })
                            .then(r => r.json())
                            .then(resp => {
                                if (resp && resp.success) {
                                    if (resp.html) itemsBody.innerHTML = resp.html;
                                    if (resp.modals) modalsContainer.innerHTML = resp.modals;
                                    finalizeBtn.disabled = !resp.finalize_enabled;

                                    checkAndLockFields();
                                } else {
                                    // keep default "no items yet" row
                                }
                            })
                            .catch(err => {
                                console.error('get_items error', err);
                            });
                    }


                    // initial actions
                    loadProducts();
                    loadExistingItems();

                    // Delegated listener for modal forms submit (edit quantity/date). When modals are injected they will contain forms that POST to controller.
                    // We'll intercept forms with class "ajax-modal-form" and submit via fetch then update table.
                    document.addEventListener('submit', function (ev) {
                        const form = ev.target;
                        if (!form.classList.contains('ajax-modal-form')) return;

                        ev.preventDefault();

                        const fd = new FormData(form);
                        fd.append('from_warehouse', fromWarehouseId);

                        const submitBtn = form.querySelector('button[type="submit"]');
                        if (submitBtn) {
                            submitBtn.disabled = true;
                            const originalText = submitBtn.innerHTML;
                            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
                        }

                        fetch(form.action || 'controllers/transfer_controller.php', { method: form.method || 'POST', body: fd, credentials: 'same-origin' })
                            .then(r => r.json())
                            .then(resp => {
                                if (!resp || !resp.success) throw new Error((resp && resp.message) ? resp.message : 'Save failed');
                                if (resp.html) itemsBody.innerHTML = resp.html;
                                if (resp.modals) modalsContainer.innerHTML = resp.modals;
                                finalizeBtn.disabled = !resp.finalize_enabled;
                                // hide any open modal
                                $('.modal').modal('hide');
                                toastSuccess(resp.message || 'Updated');
                            })
                            .catch(err => {
                                console.error('modal form submit error', err);
                                toastError(err.message || 'Failed to save changes');
                            })
                            .finally(() => {
                                if (submitBtn) {
                                    submitBtn.disabled = false;
                                    submitBtn.innerHTML = originalText;
                                }
                            });
                    });

                    // Extra: prevent adding when remaining is zero by also validating before unload (final safety)
                    window.addEventListener('beforeunload', function (e) {
                        // nothing blocking here; no warnings are added
                    });

                })();
            </script>
            <script>
                const fromWarehouseId = document.getElementById('fromWarehouseId').value;
                const destinationType = document.getElementById('destinationType');
                const toLocation = document.getElementById('toLocation');

                destinationType.addEventListener('change', function () {

                    toLocation.innerHTML = `<option value="">-- Select Destination --</option>`;
                    toLocation.disabled = true;

                    const type = this.value;
                    if (!type) return;

                    let url = "";
                    if (type === "warehouse") {
                        url = "fetch_warehouses.php";
                    } else if (type === "branch") {
                        url = "fetch_branches.php";
                    } else {
                        return;
                    }

                    fetch(url)
                        .then(r => r.json())
                        .then(data => {
                            toLocation.disabled = false;

                            data.forEach(item => {
                                // Skip the from warehouse if destination type is warehouse
                                if (type === "warehouse" && item.warehouse_id == fromWarehouseId) return;
                                let opt = document.createElement("option");

                                if (type === "warehouse") {
                                    opt.value = item.warehouse_id;
                                    opt.textContent = item.warehouse_name;
                                } else {
                                    opt.value = item.branch_id;
                                    opt.textContent = item.branch_name;
                                }

                                toLocation.appendChild(opt);
                            });
                        })
                        .catch(err => {
                            console.error("Error loading destinations", err);
                        });

                    });
            </script>

            <script>
                // Listen for clicks on any saveDateBtn, even if added dynamically
                $(document).on('click', '.saveDateBtn', function() {
                    const tn_number = '<?= $tn_number ?>'; // Pass current TN number
                    const newDate = $('#editDateModal_' + $(this).data('id') + ' .editDateInput').val();

                    // Send AJAX request to update all items for this transfer
                    $.ajax({
                        url: 'controllers/transfer_controller.php',
                        type: 'POST',
                        dataType: 'json', // automatically parse JSON
                        data: {
                            action: 'update_all_dates',
                            tn_number: tn_number,
                            new_date: newDate
                        },
                        success: function(resp) {
                            if(resp.success) {
                                Swal.fire({
                                    title: 'Success',
                                    text: 'Transfer dates updated!',
                                    icon: 'success',
                                    confirmButtonText: 'OK'
                                }).then(() => {
                                    // Reload the page to reflect new dates
                                    location.reload();
                                });
                            } else {
                                Swal.fire('Error', resp.message || 'Failed to update dates', 'error');
                            }
                        },
                        error: function(err) {
                            console.error(err);
                            Swal.fire('Error', 'AJAX request failed', 'error');
                        }
                    });
                });
            </script>
            <script>
                // Listen for clicks on any saveQtyBtn, even if dynamically added
                $(document).on('click', '.saveQtyBtn', function() {
                    const itemId = $(this).data('id'); // ID of the item to update
                    const newQty = $('#editQtyModal_' + itemId + ' .editQtyInput').val();
                    const tn_number = '<?= $tn_number ?>'; // current TN number
                    const productId = $(this).data('product');
                    const warehouseId = $(this).data('warehouse');
                    const oldQty = $(this).data('old_qty');

                    console.log(productId, oldQty,warehouseId);

                    if (!newQty || newQty < 1) {
                        Swal.fire('Error', 'Quantity must be at least 1', 'error');
                        return;
                    }

                    // Send AJAX request to update the quantity
                    $.ajax({
                        url: 'controllers/transfer_controller.php',
                        type: 'POST',
                        dataType: 'json', // automatically parse JSON
                        data: {
                            action: 'update_item_quantity',
                            tn_number: tn_number,
                            item_id: itemId,
                            new_quantity: newQty,
                            product_id:productId,
                            warehouse_id:warehouseId,
                            old_qty:oldQty
                        },
                        success: function(resp) {
                            if(resp.success) {
                                Swal.fire('Success', 'Quantity updated!', 'success').then(() => {
                                    // Reload the page to reflect the updated quantity
                                    location.reload();
                                });
                            } else {
                                Swal.fire('Error', resp.message || 'Failed to update quantity', 'error');
                            }
                        },
                        error: function(err) {
                            console.error(err);
                            Swal.fire('Error', 'AJAX request failed', 'error');
                        }
                    });
                });
            </script>
        </body>
    </html>
