<?php
    include('menu_supervisor.php');
    require_once 'model/employees_model.php';
    require_once 'model/common_model.php';

    $employees_model = new employees_model();
    $common_model    = new common_model();

    $employee_id = $_SESSION['sess_employeecode'] ?? null;

    if (!$employee_id) {
        header("Location: login.php");
        exit;
    }

    $employee_details = $employees_model->getEmployeeDetails($employee_id);
    $locations        = $common_model->getAllLocations();
    $districts        = $common_model->getDistricts();
    $nationalities    = $common_model->getNationalities();
    $employee_leaves  = $employees_model->getLeaveData($employee_id);

    $total_entitled = 30;

?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <title>Powertex | Employee Profile</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">
            <div class="content-wrapper">
                <section class="content pt-3">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-5">
                                <!-- DETAILS CARD -->
                                <div class="card card-info">

                                    <!-- CARD HEADER -->
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-user mr-1"></i> Employee Details
                                        </h3>
                                    </div>

                                    <div class="card-body p-2">

                                         <!-- IDENTITY HEADER -->
                                        <div class="d-flex align-items-center mb-3">

                                            <div class="mr-3 text-center">
                                                <a href="#" data-toggle="modal" data-target="#changePictureModal">
                                                    <?php
                                                        $defaultImage = 'default_male.avif';

                                                        if (strtolower($employee_details['gender']) === 'female') {
                                                            $defaultImage = 'default_female.avif';
                                                        }

                                                        $profileImage = !empty($employee_details['profile_picture'])
                                                            ? '../finance/images/employees/' . $employee_details['profile_picture']
                                                            : '../finance/images/employees/' . $defaultImage;
                                                    ?>
                                                    <img src="<?= $profileImage ?>"
                                                        class="img-circle elevation-2"
                                                        alt="Profile Picture"
                                                        style="width:170px;height:170px;object-fit:cover;cursor:pointer;">
                                                </a>
                                                <small class="text-muted d-block mt-1">Click image to change</small>
                                            </div>



                                            <!-- NAME + ID -->
                                            <div>
                                                <h5 class="mb-1 font-weight-bold text-info">
                                                    <?= strtoupper($employee_details['fullname']) ?>
                                                </h5>
                                                <div class="text-muted small">
                                                    <i class="fas fa-id-card mr-1"></i>
                                                    National ID: <strong><?= $employee_details['national_id_number'] ?? '—' ?></strong>
                                                </div>
                                            </div>

                                        </div>

                                        <!-- CONTACT DETAILS -->
                                        <small class="text-muted font-weight-bold pl-1 mt-2 d-block">CONTACT DETAILS</small>
                                        <hr class="mt-1 mb-2">

                                        <div class="row">

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-phone text-success"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Phone</span>
                                                        <span class="info-box-number"><?= $employee_details['phone_number'] ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-envelope text-primary"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Email</span>
                                                        <span class="info-box-number text-truncate" style="max-width:140px;">
                                                            <?= $employee_details['email'] ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-map-pin text-info"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Current Location of Stay</span>
                                                        <span class="info-box-number"><?= $employee_details['location_name'] ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-venus-mars text-primary"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Gender</span>
                                                        <span class="info-box-number"><?= $employee_details['gender'] ?></span>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>


                                        <!-- PERSONAL DETAILS -->
                                        <small class="text-muted font-weight-bold pl-1">PERSONAL DETAILS</small>
                                        <hr class="mt-1 mb-2">

                                        <div class="row">

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-birthday-cake text-warning"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">DOB / Age</span>
                                                        <span class="info-box-number">
                                                            <?= date('d M Y', strtotime($employee_details['date_of_birth'])) ?>
                                                            (<?= date_diff(date_create($employee_details['date_of_birth']), date_create('today'))->y ?> yrs)
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-flag text-info"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Nationality</span>
                                                        <span class="info-box-number"><?= $employee_details['nationality'] ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-home text-warning"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Home Village</span>
                                                        <span class="info-box-number"><?= $employee_details['home_village'] ?? '—' ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-map-marker-alt text-danger"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Home District</span>
                                                        <span class="info-box-number"><?= $employee_details['district_name'] ?? 'N/A' ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        

                                        <!-- EMPLOYMENT DETAILS -->
                                        <small class="text-muted font-weight-bold pl-1 mt-2 d-block">EMPLOYMENT DETAILS</small>
                                        <hr class="mt-1 mb-2">

                                        <div class="row">

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-briefcase text-secondary"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Post</span>
                                                        <span class="info-box-number"><?= $employee_details['postname'] ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <div class="info-box mb-2">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-file-contract text-dark"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text">Contract Type</span>
                                                        <span class="info-box-number"><?= $employee_details['contract_type'] ?></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="info-box mb-1">
                                                    <span class="info-box-icon bg-light">
                                                        <i class="fas fa-calendar-check text-success"></i>
                                                    </span>
                                                    <div class="info-box-content">
                                                        <span class="info-box-text d-flex justify-content-between align-items-center">
                                                            Start Date
                                                            <button class="btn btn-primary"
                                                                    data-toggle="modal"
                                                                    data-target="#editEmployeeModal">
                                                                <i class="fas fa-edit"></i> Edit
                                                            </button>
                                                        </span>
                                                        <span class="info-box-number"><?= $employee_details['start_date'] ?></span>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>

                                    </div>
                                </div>


                            </div>


                            <div class="col-md-7">
                                <div class="row mb-3">

                                    <div class="col-md-4">
                                        <div class="small-box bg-info">
                                            <div class="inner">
                                                <?php
                                                    $total_entitled = 0;
                                                    if (!empty($employee_leaves)) {
                                                        foreach ($employee_leaves as $leave) {
                                                            $total_entitled = $leave['total_days'];
                                                        }
                                                    }
                                                ?>
                                                <h3><?= $total_entitled ?></h3>
                                                <p>Total Entitled</p>
                                            </div>
                                            <div class="icon"><i class="fas fa-calendar"></i></div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="small-box bg-success">
                                            <div class="inner">
                                                <?php
                                                    $total_taken = 0;
                                                    if (!empty($employee_leaves)) {
                                                        foreach ($employee_leaves as $leave) {
                                                            $total_taken = $leave['total_taken'];
                                                        }
                                                    }
                                                    ?>
                                                <h3><?= $total_taken ?></h3>
                                                <p>Leave Taken</p>
                                            </div>
                                            <div class="icon"><i class="fas fa-check-circle"></i></div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="small-box bg-warning">
                                            <div class="inner">
                                                <h3><?= $total_entitled - $total_taken ?></h3>
                                                <p>Remaining</p>
                                            </div>
                                            <div class="icon"><i class="fas fa-hourglass-half"></i></div>
                                        </div>
                                    </div>

                                </div>


                                <div class="card card-secondary card-outline">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-calendar-alt mr-1"></i> Leave History
                                        </h5>
                                    </div>

                                    <div class="card-body p-0">
                                        <table class="table table-striped table-hover mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Leave Type</th>
                                                    <th>From</th>
                                                    <th>To</th>
                                                    <th>Days</th>
                                                    <th>Status</th>
                                                    <th>Operator</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            <?php if (!empty($employee_leaves)) : ?>
                                                <?php foreach ($employee_leaves as $leave) : ?>
                                                    <tr>
                                                        <td><?= $leave['leave_type'] ?></td>
                                                        <td><?= date('d M Y', strtotime($leave['start_date'])) ?></td>
                                                        <td><?= date('d M Y', strtotime($leave['end_date'])) ?></td>
                                                        <td style="text-align: center;"><?= $leave['days'] ?></td>
                                                        <td>
                                                            <?php
                                                                switch ($leave['state']) {
                                                                    case 2:
                                                                        $badgeClass = 'badge-success';
                                                                        break;
                                                                    case 1:
                                                                        $badgeClass = 'badge-warning';
                                                                        break;
                                                                    case 0:
                                                                    default:
                                                                        $badgeClass = 'badge-danger';
                                                                        break;
                                                                }
                                                            ?>
                                                            <span class="badge <?= $badgeClass ?>">
                                                                <?= $leave['status'] ?>
                                                            </span>
                                                        </td>

                                                        <td>
                                                            <?php
                                                                if ($leave['state'] == 2) {
                                                                    echo $leave['operator_name'] ?? '—';
                                                                } elseif ($leave['state'] == 0) {
                                                                    echo $leave['operator_name'] ?? '—';
                                                                } elseif ($leave['state'] == 1) {
                                                                    echo $leave['operator_name'] ?? '—';
                                                                } else {
                                                                    echo '—';
                                                                }
                                                            ?>
                                                        </td>

                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else : ?>
                                                <tr>
                                                    <td colspan="6" class="text-center text-muted p-3">
                                                        No leave records found
                                                    </td>
                                                </tr>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>

                            </div>


                            
                        </div>
                    </div>
                </section>
            </div>

            <div class="modal fade" id="changePictureModal" tabindex="-1">
                <div class="modal-dialog" role="document">
                    <form method="post" action="controllers/employees_controller.php" enctype="multipart/form-data">
                        <div class="modal-content">

                            <div class="modal-header bg-info">
                                <h5 class="modal-title">
                                    <i class="fas fa-camera mr-1"></i> Change Profile Picture
                                </h5>
                                <button type="button" class="close" data-dismiss="modal">
                                    <span>&times;</span>
                                </button>
                            </div>

                            <div class="modal-body">

                                <input type="hidden" name="action" value="update_profile_picture">
                                <input type="hidden" name="employee_code" value="<?= $employee_id ?>">

                                <div class="form-group">
                                    <label>Select Image</label>
                                    <input type="file" name="profile_picture" class="form-control"
                                        accept="image/jpeg,image/png,image/webp" required>
                                    <small class="text-muted">
                                        Allowed: JPG, PNG, WEBP (max 2MB)
                                    </small>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-info">
                                    <i class="fas fa-upload mr-1"></i> Upload
                                </button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>


            <div class="modal fade" id="editEmployeeModal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-lg" role="document">
                    <form method="post" action="controllers/employees_controller.php">
                        <div class="modal-content">

                            <div class="modal-header bg-info">
                                <h5 class="modal-title">
                                    <i class="fas fa-user-edit mr-1"></i> Edit Employee Details
                                </h5>
                                <button type="button" class="close" data-dismiss="modal">
                                    <span>&times;</span>
                                </button>
                            </div>

                            <div class="modal-body">

                                <!-- REQUIRED HIDDEN FIELDS -->
                                <input type="hidden" name="action" value="update_employee">
                                <input type="hidden" name="employee_code" value="<?= $employee_id ?>">

                                <div class="row">

                                    <div class="col-md-6">
                                        <label>Full Name</label>
                                        <input class="form-control" name="fullname"
                                            value="<?= $employee_details['fullname'] ?>" required>
                                    </div>

                                    <div class="col-md-6">
                                        <label>Gender</label>
                                        <select class="form-control" name="gender">
                                            <option value="Male" <?= $employee_details['gender']=='Male'?'selected':'' ?>>Male</option>
                                            <option value="Female" <?= $employee_details['gender']=='Female'?'selected':'' ?>>Female</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>National ID</label>
                                        <input class="form-control" name="national_id_number"
                                            value="<?= $employee_details['national_id_number'] ?>">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Date of Birth</label>
                                        <input type="date" class="form-control" name="date_of_birth"
                                            value="<?= $employee_details['date_of_birth'] ?>">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Phone Number</label>
                                        <input class="form-control" name="phone_number"
                                            value="<?= $employee_details['phone_number'] ?>">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Email Address</label>
                                        <input type="email" class="form-control" name="email"
                                            value="<?= $employee_details['email'] ?>">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Current Location</label>
                                        <select class="form-control select 2" name="nationality">
                                            <?php foreach ($nationalities as $nl): ?>
                                                <option value="<?= $nl['id'] ?>"
                                                    <?= ($employee_details['nationality_id'] == $nl['id']) ? 'selected' : '' ?>>
                                                    <?= $nl['country_name'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Home Village</label>
                                        <input class="form-control" name="home_village"
                                            value="<?= $employee_details['home_village'] ?>">
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Home District</label>
                                        <select class="form-control" name="district_id">
                                            <?php foreach ($districts as $d): ?>
                                                <option value="<?= $d['id'] ?>"
                                                    <?= ($employee_details['home_district'] == $d['district']) ? 'selected' : '' ?>>
                                                    <?= $d['district'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label>Current Location</label>
                                        <select class="form-control select 2" name="location_id">
                                            <?php foreach ($locations as $l): ?>
                                                <option value="<?= $l['loc_id'] ?>"
                                                    <?= ($employee_details['current_location'] == $l['loc_id']) ? 'selected' : '' ?>>
                                                    <?= $l['location_name'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>

                                </div>

                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-info">
                                    <i class="fas fa-save mr-1"></i> Save Changes
                                </button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>


            <!-- SCRIPTS -->
            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/dist/js/adminlte.js"></script>
            <script src="../includes/plugins/select2/js/select2.min.js"></script>

            <script>
            $('#editEmployeeForm').on('submit', function(e){
                e.preventDefault();
                $.post('controllers/employees_controller.php', $(this).serialize(), function(res){
                    if(res.status === 'success'){ location.reload(); }
                    else{ toastr.error(res.message); }
                }, 'json');
            });
            $('.select2').select2();
            </script>
        </body>
    </html>
