<?php 
include('menu_supervisor.php');
include_once 'model/stock_model.php';

$condition = $_GET['filter'] ?? null;
$allowedFilters = ['low_level','out_of_stock'];
if (!in_array($condition, $allowedFilters)) {
    $condition = null;
}

$stock_model = new stock_model();
$stock_data = $stock_model->getStockReportData($location, $condition);
$total_sales_90 = $stock_model->getTotalSalesLast90Days($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Stock Reports - Products Running Low on Stock Values</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <style>
        .table-responsive { max-height: 600px; overflow-y: auto; }
        .truncate { max-width: 150px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .table td, .table th { vertical-align: middle; }
        .progress { height: 18px; }
        .progress-bar { font-size: 11px; font-weight: bold; }
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="content-wrapper p-4">

    <div class="row mb-3 align-items-center">
        <div class="col-md-6">
            <h4 class="mb-0 font-weight-bold">
                <i class="fas fa-box-open text-warning"></i> Stock Reorder Report
            </h4>
            <small class="text-muted">Products below minimum stock threshold</small>
        </div>
        <div class="col-md-6 text-right">
            <span class="badge badge-danger mr-1"><i class="fas fa-exclamation-triangle"></i> Critical</span>
            <span class="badge badge-warning mr-1"><i class="fas fa-arrow-down"></i> Very Low</span>
            <span class="badge badge-info"><i class="fas fa-chart-line"></i> Depreciating</span>
        </div>
    </div>
    <hr>

    <div class="row mb-3">
        <div class="col-md-4">
            <input type="text" id="tableSearch" class="form-control" placeholder="Search product or category...">
        </div>
        <div class="col-md-4">
            <select id="statusFilter" class="form-control">
                <option value="">All Status</option>
                <option value="Critical Low">Critical Low</option>
                <option value="Very Low">Very Low</option>
                <option value="Stock Depreciating">Stock Depreciating</option>
            </select>
        </div>
        <div class="col-md-4 text-right">
            <a href="?filter=low_level" class="btn btn-outline-warning btn-sm">
                <i class="fas fa-arrow-down"></i> Low Stock
            </a>
            <a href="?filter=out_of_stock" class="btn btn-outline-danger btn-sm">
                <i class="fas fa-ban"></i> Out of Stock
            </a>
        </div>
    </div>

    <div class="card-body p-0 table-responsive">
        <?php if (count($stock_data) > 0): ?>
        <table class="table table-bordered table-striped mb-0">
            <thead class="thead-dark">
                <tr>
                    <th>#</th>
                    <th><i class="fas fa-box"></i> Product</th>
                    <th><i class="fas fa-tags"></i> Category</th>
                    <th class="text-center"><i class="fas fa-cubes"></i> Stock</th>
                    <th class="text-center"><i class="fas fa-level-down-alt"></i> Min</th>
                    <th class="text-center"><i class="fas fa-traffic-light"></i> Status</th>
                    <th class="text-center"><i class="fas fa-chart-pie"></i> Sales %</th>
                    <th class="text-center"><i class="fas fa-cog"></i> Action</th>
                </tr>
            </thead>
            <tbody id="transactionsBody">
                <?php foreach ($stock_data as $i => $t): 
                    $qty = (int)$t['quantity'];
                    $min = (int)$t['min_level'];

                    // STATUS
                    $ratio = $min > 0 ? ($qty / $min) * 100 : 0;
                    if ($ratio <= 30) {
                        $status = 'Critical Low';
                        $statusClass = 'bg-danger text-white';
                    } elseif ($ratio <= 50) {
                        $status = 'Very Low';
                        $statusClass = 'bg-warning';
                    } else {
                        $status = 'Stock Depreciating';
                        $statusClass = 'bg-info text-white';
                    }

                    // SALES
                    $product_sales_90 = $stock_model->getProductSalesLast90Days($location, $t['product_id']);
                    $sales_pct = ($total_sales_90 > 0) ? round(($product_sales_90 / $total_sales_90) * 100, 2) : 0;
                    $display_width = max(10, min(100, $sales_pct));
                ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= htmlspecialchars($t['product_name']) ?></td>
                    <td><?= htmlspecialchars($t['categoryname']) ?></td>
                    <td class="text-center font-weight-bold"><?= $qty ?></td>
                    <td class="text-center"><?= $min ?></td>

                    <td class="<?= $statusClass ?> font-weight-bold status-col">
                        <?php if ($status === 'Critical Low'): ?>
                            <i class="fas fa-exclamation-triangle"></i>
                        <?php elseif ($status === 'Very Low'): ?>
                            <i class="fas fa-arrow-down"></i>
                        <?php else: ?>
                            <i class="fas fa-chart-line"></i>
                        <?php endif; ?>
                        <?= $status ?>
                    </td>

                    <td>
                        <div class="progress">
                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success"
                                 style="width: <?= $display_width ?>%;">
                                 <?= $sales_pct ?>%
                            </div>
                        </div>
                    </td>

                    <td class="text-center">
                        <button class="btn btn-sm btn-outline-primary"
                            data-toggle="modal"
                            data-target="#requestStockModal"
                            data-product="<?= $t['product_id'] ?>"
                            data-name="<?= htmlspecialchars($t['product_name']) ?>">
                            <i class="fas fa-shopping-cart"></i> Request
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
        <div class="p-3 text-center text-muted">No Items Found That Require Reordering</div>
        <?php endif; ?>
    </div>
</div>

<!-- REQUEST STOCK MODAL -->
<div class="modal fade" id="requestStockModal">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h6 class="modal-title">Request Stock</h6>
                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <form id="stockRequestForm">
                <div class="modal-body">
                    <input type="hidden" name="product_id" id="req_product_id">
                    <div class="form-group">
                        <label>Product</label>
                        <input type="text" id="req_product_name" class="form-control" readonly>
                    </div>
                    <div class="form-group">
                        <label>Quantity Required</label>
                        <input type="number" name="quantity" class="form-control" required min="1">
                    </div>
                    <div class="form-group">
                        <label>Reason</label>
                        <textarea name="reason" class="form-control" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Submit Request</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script src="../includes/plugins/sweetalert2/sweetalert2.all.min.js"></script>

<script>
$('#requestStockModal').on('show.bs.modal', function (e) {
    let btn = $(e.relatedTarget);
    $('#req_product_id').val(btn.data('product'));
    $('#req_product_name').val(btn.data('name'));
});

// LIVE SEARCH + STATUS FILTER
$(document).ready(function () {
    $('#tableSearch').on('keyup', function () {
        let value = $(this).val().toLowerCase();
        $('#transactionsBody tr').each(function () {
            let product  = $(this).find('td:eq(1)').text().toLowerCase();
            let category = $(this).find('td:eq(2)').text().toLowerCase();
            if (product.includes(value) || category.includes(value)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    $('#statusFilter').on('change', function () {
        let status = $(this).val();
        $('#transactionsBody tr').each(function () {
            let rowStatus = $(this).find('.status-col').text().trim();
            if (status === '' || rowStatus === status) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
});
</script>
</body>
</html>
