<?php 
    include('menu_supervisor.php');
    include_once 'model/stock_model.php';
    include_once 'model/warehouse_model.php';

    $stock_model = new stock_model();
    $warehouse_model = new warehouse_model();

    // Default date = current month
    $start_date = $_GET['start'] ?? date("Y-m-01");
    $end_date   = $_GET['end'] ?? date("Y-m-t");

    $stock_sheet = $stock_model->getstockSheet($location, $start_date, $end_date);
    $warehouseDetails = $warehouse_model->getWarehouseDetails($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex || Stock Sheets</title>

<link rel="icon" type="image/png" href="../finance/images/favicon.png">

</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <h3 class="mb-3">
        Stock Sheet  
        <span class="text-primary"> - <?= htmlspecialchars($warehouseDetails['warehouse_name'] ?? "") ?></span>
    </h3>

    <!-- DATE RANGE FILTER + SEARCH (Same Row) -->
<form id="stockForm" method="GET" class="w-100">
    <div class="row mb-3 align-items-end">

        <!-- Start Date -->
        <div class="col-md-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="start" class="form-control" value="<?= $start_date ?>">
        </div>

        <!-- End Date -->
        <div class="col-md-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end" class="form-control" value="<?= $end_date ?>">
        </div>

        <!-- Load Button -->
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Load</button>
        </div>

        <!-- Global Filter -->
        <div class="col-md-2">
            <label class="form-label">&nbsp;</label>
            <input type="text" id="filter_global" class="form-control text-start" placeholder="Search Products">
        </div>

        <!-- Generate PDF -->
        <div class="col-md-2">
            <label class="form-label">&nbsp;</label>
            <button type="button" id="pdfBtn" class="btn btn-danger w-100 d-flex justify-content-center align-items-center">
                <span id="pdfText">Generate PDF</span>
                <span id="pdfSpinner" class="spinner-border spinner-border-sm ml-2 d-none"></span>
            </button>

        </div>

        <!-- Hidden inputs for PDF -->
        <input type="hidden" name="stock_sheet" value="stock_sheet">
        <input type="hidden" name="start_date" value="<?= $start_date ?>">
        <input type="hidden" name="end_date" value="<?= $end_date ?>">
        <input type="hidden" name="warehouse_id" value="<?= $location ?>">

    </div>
</form>





    <div class="table">
        <table class="table table-bordered table-striped" id="stockTable">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Category</th>
                    <th class="text-center">Opening&nbsp;Stock</th>
                    <th class="text-center">Transfer In</th>
                    <th class="text-center">Total</th>
                    <th class="text-center">Transfer&nbsp;Out</th>
                    <th class="text-center">Sold</th>
                    <th class="text-center">Total&nbsp;Out</th>
                    <th class="text-center">Closing&nbsp;Stock</th>
                    <th class="text-center">Current&nbsp;Quantity</th>

                </tr>
            </thead>

            <tbody>
                <?php foreach ($stock_sheet as $s): 
                    $opening = (int)$s['opening_stock'];
                    $in = (int)$s['transfer_in'];
                    $out = (int)$s['transfer_out'];
                    $sold = (int)$s['sold'];
                    $current = (int)$s['current_qty'];

                    $total_in = $opening + $in;
                    $total_out = $out + $sold;
                    $closing = $opening + $in - $out - $sold;
                ?>
                <tr>
                    <td><?= $s['product_name'] ?></td>
                    <td><?= $s['categoryname'] ?></td>
                    <td class="text-center"><?= $opening ?></td>
                    <td class="text-center"><?= $in ?></td>
                    <td class="fw-bold text-success text-center"><?= $total_in ?></td>
                    <td class="text-center"><?= $out ?></td>
                    <td class="text-center"><?= $sold ?></td>
                    <td class="fw-bold text-danger text-center"><?= $total_out ?></td>
                    <td class="fw-bold text-center"><?= $closing ?></td>
                    <td class="fw-bold text-center"><?= $current ?></td>

                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<!-- DO NOT REMOVE THESE, PRESERVED EXACTLY -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>

<script>
// GLOBAL SEARCH FILTER
$("#filter_global").on("keyup", function () {
    let value = $(this).val().toLowerCase();
    $("#stockTable tbody tr").filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
});
</script>

<script>
document.getElementById('pdfBtn').addEventListener('click', function() {

    let btn = document.getElementById("pdfBtn");

    // Disable button
    btn.disabled = true;

    // Change text
    document.getElementById("pdfText").innerText = "Generating...";

    // Show spinner
    document.getElementById("pdfSpinner").classList.remove("d-none");

    // Submit form
    const form = document.getElementById('stockForm');
    form.action = 'generate_pdf.php';
    form.method = 'POST';
    form.submit();

    // Auto re-enable button in case download event isn't detected
    setTimeout(function(){
        btn.disabled = false;
        document.getElementById("pdfText").innerText = "Generate PDF";
        document.getElementById("pdfSpinner").classList.add("d-none");
    }, 8000); // safe timeout
});
</script>


</body>
</html>
