<?php 
include('menu_supervisor.php');
include_once 'model/stock_model.php';

$stock_model = new stock_model();

// Get transfer type from URL parameter (?type=in|out|all)
$type = $_GET['type'] ?? 'all';

// Fetch transfers based on type
$transfers = $stock_model->getStockTransfers($location, $type);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex || Stock Transfers</title>
<link rel="icon" type="image/png" href="../finance/images/favicon.png">

<!-- Bootstrap 4 -->
<link rel="stylesheet" href="../includes/plugins/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="../includes/plugins/fontawesome-free/css/all.min.css">

<style>
    .table th, .table td { text-align: center; vertical-align: middle; }
    .input-group-text { border-right: 0; }
    .form-control { border-left: 0; }
    .filter-row { margin-bottom: 15px; }
</style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
    <section class="content">
        <!-- Title + Filter Row -->
        <div class="d-flex justify-content-between align-items-center filter-row">
            <h4><i class="fas fa-exchange-alt text-primary"></i> Stock Transfers</h4>
            <div class="input-group" style="width: 250px;">
                <div class="input-group-prepend">
                    <span class="input-group-text bg-white"><i class="fas fa-search"></i></span>
                </div>
                <input type="text" id="filter_global" class="form-control" placeholder="Search…">
            </div>
        </div>

        <!-- Table -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">List of Stock Transfers</h5>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-striped table-sm" id="transfers-table">
                    <thead>
                        <tr>
                            <th>Transfer Note</th>
                            <th>Transfer Date</th>
                            <th>Transfer From</th>
                            <th>Transfer To</th>
                            <th>No. of Items</th>
                            <th>Transfer State</th>
                            <th>Initiated By</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($transfers)): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted">No stock transfers found.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach($transfers as $transfer): ?>
                                <tr class="<?= $transfer['transfer_type'] === 'IN' ? 'bg-light' : 'bg-white' ?>">
                                    <td style="text-align: left;"><?= htmlspecialchars($transfer['delivery_note_number']) ?></td>
                                    <td style="text-align: left;"><?= date('d F Y', strtotime($transfer['transfer_date'])) ?></td>
                                    <td style="text-align: left;"><?= htmlspecialchars($transfer['source_name']) ?></td>
                                    <td style="text-align: left;"><?= htmlspecialchars($transfer['destination_name']) ?></td>
                                    <td><?= htmlspecialchars($transfer['number_of_items']) ?></td>
                                    <td class="<?=
                                            $transfer['transfer_state'] == 2 ? 'bg-success text-white' :
                                            ($transfer['transfer_state'] == 1 ? 'bg-warning text-dark' : 
                                            ($transfer['transfer_state'] == 3 ? 'bg-secondary text-white' : 'bg-danger text-white'))
                                        ?>">
                                        <?= 
                                            $transfer['transfer_state'] == 2 ? 'Accepted' :
                                            ($transfer['transfer_state'] == 1 ? 'Pending' : 
                                            ($transfer['transfer_state'] == 3 ? 'Cancelled' : 'Declined'))
                                        ?>
                                    </td>

                                    <td><?= htmlspecialchars($transfer['initiated_by']) ?></td>
                                    <td>
                                        <a href="transfer_note.php?transfer_to=<?= $transfer['transfer_to'] ?>&id=<?= $transfer['delivery_note_number'] ?>" class="btn btn-info btn-sm">
                                            <i class="fas fa-file-invoice"></i> Transfer Note
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</div>

<!-- Scripts -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>

<script>
// Global search filter
$(document).ready(function(){
    $("#filter_global").on("keyup", function(){
        var value = $(this).val().toLowerCase();
        $("#transfers-table tbody tr").filter(function(){
            $(this).toggle($(this).text().toLowerCase().includes(value));
        });
    });
});
</script>

</body>
</html>
